/******************************************************************************\
**
**     COMPANY:	LDW Software
**
**      MODULE:	Story
**
** DESCRIPTION:	Story telling scene
**
**      AUTHOR:	Adrian Francis
**
\******************************************************************************/

#ifndef STORY_H
#define STORY_H

/******************************************************************************\
** LIBRARY INCLUDES
\******************************************************************************/
#include "ldwScene.h"
#include "../Utils/theGraphicsManager.h"
#include "../Utils/theStringManager.h"
#include "../Sound/Sound.h"
#include "../Story/PageInterface.h"

/******************************************************************************\
** CONSTANT DEFINITIONS
\******************************************************************************/
const int Story_c_iMaxPages = 5;
const int Story_c_iMaxTextLines = 15;
const int Story_c_iMaxImages = 16;
const float Story_c_fDefaultTextFadeInSpeed = 0.01f;
const float Story_c_fFadeOutSpeed = 0.04f;
const float Story_c_fSoundTrackMuteVolume = 0.20f;
const float Story_c_fSoundTrackMuteSpeed = 0.05f;

/******************************************************************************\
** CLASS DEFINITIONS
\******************************************************************************/
class CStory
{
public:

	//class enumerations
	enum EStory
	{
		eStory_Intro = 0,
		eStory_MidGame,
		eStory_EndGame,

		eStory_NumberOf
	};

private:

	enum EButton
	{
		eButton_Skip = 0,
		eButton_Yes,
		eButton_No,

		eButton_NumberOf
	};

	enum EState
	{
		eState_FadeImage,
		eState_FadeText,
		eState_Waiting,
		eState_FadeOut
	};

	//class structures
	struct SStory
	{
		int					m_iNumPages;
		IPage *				m_pPage[Story_c_iMaxPages];
	};

	struct SImage
	{
		EImage				m_eImage;
		int					m_iCell;
		float				m_fXPos;
		float				m_fYPos;
		float				m_fAlpha;
		float				m_fScale;

		bool				m_bHasTargetAlpha;
		float				m_fTargetAlpha;
		int					m_iAlphaTime;

		bool				m_bHasTargetScale;
		float				m_fTargetScale;
		int					m_iScaleTime;

		bool				m_bHasTargetPos;
		float				m_fTargetXPos;
		float				m_fTargetYPos;
		int					m_iPosTime;
	};

	//class data
	SStory					m_sStory[eStory_NumberOf];

	EStory					m_eStory;
	int						m_iPage;
	EState					m_eState;
	float					m_fFadeAlpha;
	int						m_iFadeTextLine;
	float					m_fTextFadeInSpeed;

	ldwColor				m_sBackgroundColor;
	ldwColor				m_sTextColor;
	ldwPoint				m_sTextPos;

	StringId				m_eText[Story_c_iMaxTextLines];
	int						m_iNumTextLines;

	SImage					m_sImage[Story_c_iMaxImages];
	int						m_iNumImages;

	int						m_iWaitTimer;
	bool					m_bSkip;

	ESound					m_eNarrative;
	bool					m_bPlayedNarrative;

	//class methods
	//setup
	public:		CStory();
	private:	void AddPage(const EStory eStory, IPage *pPage);

	//process
	public:		void Enter();
	public:		void Exit();
	public:		void Draw();
	public:		void Update();

	public:		void HandleMouseDown();

	private:	void GotoPage(const int iPage);

	public:		void AddTutorialTipButtons();

	public:		void AddText(const StringId eString);
	public:		const int AddImage(const EImage eImage, const int iXPos, const int iYPos, const int iCell = 0);
	public:		void ReleaseImages();

	//access
	public:		void SetStory(const EStory eStory);
	public:		const EStory Story() const { return m_eStory; }
	public:		void SetTextPos(const int iXPos, const int iYPos);
	public:		void SetAlpha(const int iImage, const float fAlpha);
	public:		const float Alpha(const int iImage) const { return m_sImage[iImage].m_fAlpha; }
	public:		void SetTargetAlpha(const int iImage, const float fAlpha, const int iTime = 30);
	public:		void SetScale(const int iImage, const float fScale);
	public:		const float Scale(const int iImage) const { return m_sImage[iImage].m_fScale; }
	public:		void SetTargetScale(const int iImage, const float fScale, const int iTime = 60);
	public:		void SetPos(const int iImage, const int iXPos, const int iYPos);
	public:		void SetTargetPos(const int iImage, const int iXPos, const int iYPos, const int iTime = 30);
	public:		const int XPos(const int iImage) const { return (int)m_sImage[iImage].m_fXPos; }
	public:		const int YPos(const int iImage) const { return (int)m_sImage[iImage].m_fYPos; }
	public:		void SetTextSpeed(const float fSpeed) { m_fTextFadeInSpeed = fSpeed; }
	public:		const bool IsTextDisplayed() const { return m_iFadeTextLine >= m_iNumTextLines; }
	public:		void Wait(const int iTime) { m_iWaitTimer = iTime; }
	public:		const bool IsSkipPressed() { return m_bSkip; }
	public:		void PlayNarrative(const ESound eSound);
};

/******************************************************************************\
** GLOBAL DECLARATIONS
\******************************************************************************/
extern CStory		Story;

#endif

/******************************************************************************\
** END OF FILE
\******************************************************************************/